/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.scoreboard.display.lines;

import java.util.Optional;
import net.impactdev.impactor.api.scoreboards.AssignedScoreboard;
import net.impactdev.impactor.api.scoreboards.display.text.ScoreboardComponent;
import net.impactdev.impactor.api.scoreboards.lines.LineTickConsumer;
import net.impactdev.impactor.api.scoreboards.lines.ScoreboardLine;
import net.impactdev.impactor.api.scoreboards.lines.ScoreboardLineBuilder;
import net.impactdev.impactor.api.scoreboards.score.Score;
import net.impactdev.impactor.api.scoreboards.updaters.UpdaterConfiguration;
import net.impactdev.impactor.minecraft.scoreboard.display.lines.DisplayedLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImpactorScoreboardLine
implements ScoreboardLine {
    private final ScoreboardComponent text;
    private final Score score;
    private final UpdaterConfiguration<?> updater;
    private final LineTickConsumer lineTickConsumer;

    public ImpactorScoreboardLine(ImpactorScoreboardLineBuilder builder) {
        this.text = builder.text;
        this.score = builder.score;
        this.updater = builder.updater;
        this.lineTickConsumer = builder.lineTickConsumer;
    }

    @Override
    @NotNull
    public Score score() {
        return this.score;
    }

    public ScoreboardLine.Displayed create(AssignedScoreboard scoreboard) {
        return new DisplayedLine(scoreboard, this);
    }

    @Override
    public ScoreboardComponent component() {
        return this.text;
    }

    @Override
    @Nullable
    public UpdaterConfiguration<?> updater() {
        return this.updater;
    }

    Optional<LineTickConsumer> lineTickConsumer() {
        return Optional.ofNullable(this.lineTickConsumer);
    }

    public static final class ImpactorScoreboardLineBuilder
    implements ScoreboardLineBuilder {
        private ScoreboardComponent text;
        private UpdaterConfiguration<?> updater;
        private Score score;
        private LineTickConsumer lineTickConsumer;

        @Override
        public ScoreboardLineBuilder text(ScoreboardComponent component) {
            this.text = component;
            return this;
        }

        @Override
        public ScoreboardLineBuilder score(Score score) {
            this.score = score;
            return this;
        }

        @Override
        public ScoreboardLineBuilder updater(UpdaterConfiguration<?> config) {
            this.updater = config;
            return this;
        }

        @Override
        public ScoreboardLineBuilder onTickLine(LineTickConsumer resolver) {
            this.lineTickConsumer = resolver;
            return this;
        }

        @Override
        public ScoreboardLine build() {
            return new ImpactorScoreboardLine(this);
        }
    }
}

